/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.LiveTextInfo;
import components.TextComponent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class LiveText
extends TextComponent {
    private LiveTextInfo ltp;
    private Color backc;

    public LiveText(Font f, Color c, Color b, Point p) {
        super(f, c, p);
        this.backc = b;
    }

    public void draw(Graphics g, long time) {
        if (this.ltp == null) {
            return;
        }
        String text = this.ltp.getLiveTextData();
        if (text == null) {
            return;
        }
        Rectangle pt = this.calculateTextArea(text, g);
        g.setColor(this.backc);
        g.fillRect(pt.x, pt.y, pt.width, pt.height);
        g.setColor(Color.BLACK);
        g.drawRect(pt.x, pt.y, pt.width, pt.height);
        g.setColor(this.getColor());
        g.setFont(this.getFont());
        g.drawString(text, this.getX(), this.getY());
    }

    public void setLiveTextProvider(LiveTextInfo l) {
        this.ltp = l;
    }

    public LiveTextInfo getLiveTextProvider() {
        return this.ltp;
    }
}

