/*
 * Decompiled with CFR 0.152.
 */
package network;

public class Packet {
    byte[] m_buffer;
    int m_offset;
    int m_length;
    int m_real_offset;
    int m_header_size = 2;

    public Packet(byte[] buffer, int length, int real_offset) {
        this.m_real_offset = real_offset;
        this.m_header_size += real_offset;
        this.m_buffer = buffer;
        this.m_offset = this.m_header_size;
        this.m_length = length;
    }

    public Packet(byte[] buffer, int length) {
        this(buffer, length, 0);
    }

    public final byte[] getData() {
        return this.m_buffer;
    }

    public final int getSize() {
        return this.m_length;
    }

    final void setOffset(int offset) {
        this.m_offset = offset;
    }

    public final int getOffset() {
        return this.m_offset;
    }

    public final void resetChunks() {
        this.m_offset = this.m_header_size;
    }

    public final boolean hasChunks() {
        return this.m_offset < this.m_length + this.m_real_offset;
    }
}

