/*
 * Decompiled with CFR 0.152.
 */
package protocol.cstrike;

import network.cstrike.ChunkPacket;

public class PlayerEvent {
    private String m_name;
    private String m_text;
    private short m_posX;
    private short m_posY;
    private byte m_health;
    private byte m_id;
    private byte m_team;
    private short m_angle;
    private byte m_kills;
    private byte m_deaths;
    private byte m_state;
    private byte m_bits;
    private byte m_weapon;
    private byte m_icons;
    public static final byte ORIGIN = 1;
    public static final byte HEALTH = 2;
    public static final byte STATE = 4;
    public static final byte KILLS = 8;
    public static final byte TEAM = 16;
    public static final byte NAME = 32;
    public static final byte WEAPON = 64;
    public static final byte ICONS = -128;

    public final boolean isSet(byte a) {
        return (this.m_bits & a) != 0;
    }

    public PlayerEvent(ChunkPacket pp) {
        this.m_id = pp.getHeader();
        this.m_bits = pp.readByte();
        if (this.isSet((byte)1)) {
            this.m_posX = pp.readShort();
            this.m_posY = pp.readShort();
            this.m_angle = pp.readShort();
        }
        if (this.isSet((byte)2)) {
            this.m_health = pp.readByte();
        }
        if (this.isSet((byte)4)) {
            this.m_state = pp.readByte();
        }
        if (this.isSet((byte)8)) {
            this.m_kills = pp.readByte();
            this.m_deaths = pp.readByte();
        }
        if (this.isSet((byte)16)) {
            this.m_team = pp.readByte();
        }
        if (this.isSet((byte)32)) {
            this.m_name = pp.readString();
        }
        if (this.isSet((byte)64)) {
            this.m_weapon = pp.readByte();
        }
        if (this.isSet((byte)-128)) {
            this.m_icons = pp.readByte();
        }
    }

    public byte getPlayerID() {
        return this.m_id;
    }

    public byte getTeam() {
        return this.m_team;
    }

    public byte getHealth() {
        return this.m_health;
    }

    public short getX() {
        return this.m_posX;
    }

    public short getY() {
        return this.m_posY;
    }

    public short getAngle() {
        return this.m_angle;
    }

    public String getName() {
        return this.m_name;
    }

    public String getText() {
        return null;
    }

    public byte getKills() {
        return this.m_kills;
    }

    public byte getDeaths() {
        return this.m_deaths;
    }

    public byte getState() {
        return this.m_state;
    }

    public byte getWeapon() {
        return this.m_weapon;
    }

    public byte getIcons() {
        return this.m_icons;
    }
}

