/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.ItemViewInfo;
import components.SpectatorComponent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class ItemView
implements SpectatorComponent {
    protected ItemViewInfo item;

    public ItemView(ItemViewInfo p) {
        this.item = p;
    }

    public void draw(Graphics g, long time) {
        if (!this.item.isVisible()) {
            return;
        }
        Point dd = this.item.getOrigin(time);
        int sizeBig = this.item.getSize();
        int sizeSmall = sizeBig >> 1;
        int x = dd.x - sizeSmall;
        int y = dd.y - sizeSmall;
        g.setColor(this.item.getColor(time));
        g.fillOval(x, y, sizeBig, sizeBig);
        int health = this.item.getHealth();
        if (health < 100) {
            double ratrio = (double)(100 - health) / 100.0;
            int angle = (int)(360.0 * ratrio);
            g.setColor(this.item.getDeadColor());
            g.fillArc(x, y, sizeBig, sizeBig, 90 - angle, angle);
        }
        g.setColor(Color.BLACK);
        g.drawOval(x, y, sizeBig, sizeBig);
    }
}

