/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.awt.Point;

class MapTransform {
    double scale;
    int angle;
    double tranX;
    double tranY;

    public MapTransform(int sx, int sy, int x, int y, double s, int a) {
        this.angle = a;
        this.scale = 8.0 / s;
        if (this.angle == 0) {
            this.tranX = (double)sx / 2.0 + (double)y / this.scale;
            this.tranY = (double)sy / 2.0 + (double)x / this.scale;
        } else {
            this.tranX = (double)sx / 2.0 - (double)x / this.scale;
            this.tranY = (double)sy / 2.0 + (double)y / this.scale;
        }
    }

    public int getAngle(int a) {
        a += 45;
        if (this.angle == 1) {
            a -= 90;
        }
        return a;
    }

    public Point getOrigin(int x, int y) {
        int pY;
        int pX;
        if (this.angle == 0) {
            pX = (int)(this.tranX - (double)y / this.scale);
            pY = (int)(this.tranY - (double)x / this.scale);
        } else {
            int px = (int)(this.tranX + (double)x / this.scale);
            int py = (int)(this.tranY - (double)y / this.scale);
            pX = px;
            pY = py;
        }
        return new Point(pX, pY);
    }
}

