/*
 * Decompiled with CFR 0.152.
 */
package engine;

import components.StaticText;
import engine.RateMeasure;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import network.Packet;
import network.cstrike.ChunkPacket;
import network.cstrike.HeartBeatPacket;
import protocol.cstrike.BombEvent;
import protocol.cstrike.ChatEvent;
import protocol.cstrike.DeathEvent;
import protocol.cstrike.GameProtocol;
import protocol.cstrike.GrenadeEvent;
import protocol.cstrike.HeartBeatEvent;
import protocol.cstrike.MapEvent;
import protocol.cstrike.MsgEvent;
import protocol.cstrike.PlayerEvent;
import protocol.cstrike.RoundTimeEvent;
import protocol.cstrike.ScoreEvent;

public class Receiver
implements Runnable {
    private DatagramSocket socket;
    private GameProtocol dest;
    private volatile Thread thread;
    private StaticText error;
    private RateMeasure rate;
    private Applet applet;
    DatagramPacket datagram;
    DatagramPacket heartbeat;
    HeartBeatPacket hrtbeat;
    private byte[] m_demo;
    private boolean m_demo_play;
    public static byte DEMO_VERSION = (byte)2;

    public Receiver(Applet ap, GameProtocol dp, StaticText errorMsg, StaticText rateMsg) {
        this.applet = ap;
        this.dest = dp;
        this.error = errorMsg;
        this.m_demo_play = false;
        String m_demofilename = this.applet.getParameter("demo");
        if (m_demofilename != null && !m_demofilename.equals("")) {
            errorMsg.setText("Loading demo, please wait...");
            try {
                int c;
                URL demo = new URL(this.applet.getCodeBase(), m_demofilename);
                BufferedInputStream bins = new BufferedInputStream(demo.openStream());
                ByteArrayOutputStream src = new ByteArrayOutputStream();
                BufferedOutputStream bff = new BufferedOutputStream(src);
                byte[] buffer2 = new byte[1024];
                while ((c = bins.read(buffer2, 0, 1024)) != -1) {
                    bff.write(buffer2, 0, c);
                }
                bff.close();
                this.m_demo = src.toByteArray();
                this.m_demo_play = true;
            }
            catch (Exception e) {
                errorMsg.setText("ERROR: Demo not found...");
            }
        }
        if (!this.m_demo_play) {
            try {
                this.socket = new DatagramSocket();
                this.socket.setSoTimeout(1000);
                String[] serveradd = this.applet.getParameter("server").split(":");
                InetAddress host = InetAddress.getByName(serveradd[0]);
                int port = Integer.parseInt(serveradd[1]);
                byte[] buffer = new byte[512];
                this.datagram = new DatagramPacket(buffer, buffer.length);
                this.datagram.setAddress(host);
                this.datagram.setPort(port);
                byte[] buffer2 = new byte[8];
                this.heartbeat = new DatagramPacket(buffer2, buffer2.length);
                this.heartbeat.setAddress(host);
                this.heartbeat.setPort(port);
                this.hrtbeat = new HeartBeatPacket(buffer2);
                this.hrtbeat.setNew(true);
                this.error.setText("Waiting for response from " + serveradd[0] + ":" + serveradd[1] + "...");
            }
            catch (SocketException e) {
                this.error.setText("ERROR: " + e.getMessage());
            }
            catch (Exception e) {
                this.error.setText("ERROR: Applet parameters are improper (check your's configuration)");
            }
        }
        this.rate = new RateMeasure(rateMsg);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void terminate() {
        this.rate.terminate();
        this.thread = null;
    }

    public final short readShort(byte[] body, int pos) {
        short result = (short)(body[pos++] << 8 & 0xFF00);
        result = (short)(result | (short)(0xFF & body[pos++]));
        return result;
    }

    public final byte readByte(byte[] body, int pos) {
        byte result = body[pos++];
        return result;
    }

    public synchronized void run() {
        long heatBeatTime = System.currentTimeMillis();
        int timeout = 0;
        int sendtimes = 2;
        int demo_pos = 0;
        int packets_num = 0;
        Packet packet = null;
        byte[] temp_buf = new byte[512];
        block5: while (this.thread == Thread.currentThread()) {
            try {
                if (this.m_demo_play) {
                    if (demo_pos >= this.m_demo.length) {
                        this.error.setText("End of demo...");
                        break;
                    }
                    if (demo_pos == 0 && this.m_demo[demo_pos++] != DEMO_VERSION) {
                        this.error.setText("ERROR: This applet can't read that demo, my version is " + DEMO_VERSION + " and demo is " + this.m_demo[0]);
                        break;
                    }
                    if (--packets_num <= 0) {
                        packets_num = this.readByte(this.m_demo, demo_pos);
                        ++demo_pos;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                    int toread = this.readShort(this.m_demo, demo_pos);
                    demo_pos += 2;
                    int a = 0;
                    while (a < toread) {
                        temp_buf[a] = (byte)(this.m_demo[demo_pos++] ^ 0xAA);
                        ++a;
                    }
                    packet = new Packet(temp_buf, toread);
                } else {
                    long current = System.currentTimeMillis();
                    if (heatBeatTime < current) {
                        heatBeatTime = current + 2500L;
                        this.socket.send(this.heartbeat);
                        if (sendtimes <= 0) {
                            this.hrtbeat.setNew(false);
                        } else {
                            --sendtimes;
                        }
                    }
                    this.socket.receive(this.datagram);
                    timeout = 0;
                    this.rate.add(this.datagram.getLength());
                    packet = new Packet(this.datagram.getData(), this.datagram.getLength());
                }
                while (packet.hasChunks()) {
                    ChunkPacket chunk = new ChunkPacket(packet);
                    if (chunk.isPacket(31)) {
                        PlayerEvent pe = new PlayerEvent(chunk);
                        this.dest.gamePlayer(pe);
                        continue;
                    }
                    if (chunk.isPacket(41)) {
                        RoundTimeEvent rte = new RoundTimeEvent(chunk);
                        this.dest.gameRoundTime(rte);
                        continue;
                    }
                    if (chunk.isPacket(36)) {
                        ScoreEvent me = new ScoreEvent(chunk);
                        this.dest.gameScore(me);
                        continue;
                    }
                    if (chunk.isPacket(39)) {
                        GrenadeEvent me = new GrenadeEvent(chunk);
                        this.dest.gameGrenade(me);
                        continue;
                    }
                    if (chunk.isPacket(35)) {
                        ChatEvent me = new ChatEvent(chunk);
                        this.dest.gameChat(me);
                        continue;
                    }
                    if (chunk.isPacket(33)) {
                        DeathEvent me = new DeathEvent(chunk);
                        this.dest.gameDeath(me);
                        continue;
                    }
                    if (chunk.isPacket(34)) {
                        MsgEvent me = new MsgEvent(chunk);
                        this.dest.gameMsg(me);
                        continue;
                    }
                    if (chunk.isPacket(40)) {
                        BombEvent be = new BombEvent(chunk);
                        this.dest.gameBomb(be);
                        continue;
                    }
                    if (chunk.isPacket(38)) {
                        HeartBeatEvent be = new HeartBeatEvent(chunk);
                        if (be.getVersion() == 2) continue;
                        this.terminate();
                        this.error.setText("ERROR: This applet differs in version with server, my is 2 and server's is " + be.getVersion() + " (please mail to webmaster)");
                        continue block5;
                    }
                    if (!chunk.isPacket(32)) continue block5;
                    MapEvent me = new MapEvent(chunk);
                    this.dest.gameMap(me);
                }
            }
            catch (InterruptedIOException e) {
                if (++timeout < 5) continue;
                this.error.setText("ERROR: Server at " + this.applet.getParameter("server") + " seems to be off-line...");
                sendtimes = 2;
                this.hrtbeat.setNew(true);
            }
            catch (IOException e) {
                this.error.setText("ERROR: " + e.getMessage());
            }
        }
    }
}

