/*
 * Decompiled with CFR 0.152.
 */
package game.cstrike;

import components.cstrike.GrenadeViewInfo;
import game.Walk;
import game.cstrike.Game;
import java.awt.Color;
import java.awt.Point;

public class Grenade
implements GrenadeViewInfo {
    static final long[] m_times = new long[]{21700L, 2200L, 2200L};
    static final Color[] m_grenColor = new Color[]{new Color(100, 200, 100), new Color(200, 200, 200), new Color(200, 100, 100)};
    static final Color[] m_grenExplosionColor = new Color[]{new Color(255, 255, 255, 150), new Color(255, 255, 255, 100), new Color(255, 50, 0, 100)};
    public static final int VISIBLE = 1;
    public static final int FLY = 2;
    public static final int EXPLODING = 4;
    public static final int SPAWN = 8;
    public Walk m_walk;
    private long m_moveframe;
    private Game m_game;
    private byte m_state;
    private byte m_type = 0;
    private long m_time;
    private boolean m_explode;
    private int m_radius;

    public Grenade(Game g) {
        this.m_game = g;
        this.m_time = 0L;
        this.m_walk = new Walk();
    }

    public void setType(byte b) {
        this.m_type = b;
    }

    public Color getColor(long time) {
        return m_grenColor[this.m_type];
    }

    public int getHealth() {
        return 100;
    }

    public void setMoveDest(Point p, boolean instant) {
        this.m_walk.setWalk(p, instant);
    }

    public Point getOrigin(long time) {
        if (time != this.m_moveframe) {
            this.m_walk.doMove();
        }
        this.m_moveframe = time;
        Point x = this.m_walk.getWalk();
        return this.m_game.map.getOrigin(x.x, x.y);
    }

    public Color getDeadColor() {
        return m_grenColor[this.m_type];
    }

    public void setState(byte s) {
        this.m_state = s;
        if ((this.m_state & 8) != 0) {
            this.m_time = System.currentTimeMillis() + m_times[this.m_type];
            this.m_radius = 0;
            this.m_explode = false;
        }
        if ((this.m_state & 4) != 0) {
            this.m_radius = 50;
            this.m_explode = true;
        }
    }

    public boolean isVisible() {
        if (this.m_radius != 0 || this.m_time != 0L && System.currentTimeMillis() < this.m_time) {
            return true;
        }
        this.m_time = 0L;
        return false;
    }

    public int getSize() {
        return 12;
    }

    public Color getGrenadeColor() {
        return m_grenExplosionColor[this.m_type];
    }

    public boolean isExploding() {
        return this.m_explode;
    }

    public int getRadius() {
        if (this.m_radius > 0) {
            this.m_radius -= 10;
        }
        return 50 - this.m_radius;
    }
}

