#include <amxmodx>
#include <amxmisc>

#define PLUGIN "Control Panel"
#define VERSION "1.0"
#define AUTHOR "Felix_Font"

#define ADMIN ADMIN_RCON

new rcon_last[64]

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_clcmd("cpanel","cpanel_menu")
	register_clcmd("say /cpanel","cpanel_menu")
	register_clcmd("say_team /cpanel","cpanel_menu")
	register_clcmd("cmd_message","message")
	register_clcmd("server_cmd","CommandMessage")
	register_clcmd("rcon_message","message_2")
	register_clcmd("new_rcon_password","CommandMessage_2")
	register_dictionary("cpanel.txt") 

}
public cpanel_menu(id)
{
	if (get_user_flags(id) & ADMIN)
	{
	static cpanel_menu[64]
	formatex(cpanel_menu, charsmax(cpanel_menu), "%L", id, "CPANEL_MENU_NAME")
	new i_Menu = menu_create(cpanel_menu, "menu_handler")

	static restart_round[64], stop_server[64], restart_server[64], reload_admin[64], server_cmd_message[128], rcon_password_menu[128], amxmodx_menu[64], Next[64], Back[64], Exit[64]
	formatex(restart_round, charsmax(restart_round), "%L", id, "RESTART_ROUND")
	formatex(stop_server, charsmax(stop_server), "%L", id, "STOP_SERVER")
	formatex(restart_server, charsmax(restart_server), "%L", id, "RESTART_SERVER")
	formatex(reload_admin, charsmax(reload_admin), "%L", id, "RELOAD_ADMINS")
	formatex(server_cmd_message, charsmax(server_cmd_message), "%L", id, "SERVER_CMD")
	formatex(rcon_password_menu, charsmax(rcon_password_menu), "%L", id, "RCON_PASSWORD_MENU")
	formatex(amxmodx_menu, charsmax(amxmodx_menu), "%L", id, "AMXMODX_MENU")
	
	formatex(Next, charsmax(Next), "%L", id, "NEXT")
	formatex(Back, charsmax(Back), "%L", id, "BACK")
	formatex(Exit, charsmax(Exit), "%L", id, "EXIT")
	
	menu_additem(i_Menu, restart_round, "1")
	menu_additem(i_Menu, stop_server, "2")
	menu_additem(i_Menu, restart_server, "3")
	menu_additem(i_Menu, reload_admin, "4")
	menu_additem(i_Menu, server_cmd_message, "5")
	menu_additem(i_Menu, rcon_password_menu, "6")
	menu_additem(i_Menu, amxmodx_menu, "7")

	menu_setprop(i_Menu, MPROP_NEXTNAME, Next)
	menu_setprop(i_Menu, MPROP_BACKNAME, Back)
	menu_setprop(i_Menu, MPROP_EXITNAME, Exit)
	menu_display(id, i_Menu, 0)
	}
	else
	{
	ColorChat(id, "%L", id, "NOT_FLAG")
	}
}

public menu_handler(id, menu, item)
{
	if (get_user_flags(id) & ADMIN)
	{
	if (item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}

	new s_Data[6], s_Name[64], i_Access, i_Callback
	menu_item_getinfo(menu, item, i_Access, s_Data, charsmax(s_Data), s_Name, charsmax(s_Name), i_Callback)
        
	new i_Key = str_to_num(s_Data)

	switch(i_Key)
	{
	case 1:
	{
		if (get_user_flags(id) & ADMIN)
		{
		server_cmd("sv_restartround 1");
		ColorChat(id, "%L", id, "ROUND_RESTARTED");
		}
	}
	case 2:
	{
		if (get_user_flags(id) & ADMIN)
		{
		ColorChat(id, "%L", id, "SERVER_KILLED");
		set_task(5.0,"server_kill",0,_,_,"b");
		}
	}
	case 3:
	{
		if (get_user_flags(id) & ADMIN)
		{
		ColorChat(id, "%L", id, "SERVER_RESTARTED");
		set_task(5.0,"server_restart",0,_,_,"b");
		}
	}
	case 4:
	{
		if (get_user_flags(id) & ADMIN)
		{
		client_cmd(id, "amx_reloadadmins");
		ColorChat(id, "%L", id, "ADMINS_RELOADING");
		}
	}
	case 5:
	{
		if (get_user_flags(id) & ADMIN)
		{
		client_cmd(id,"cmd_message");
		}
	}
	case 6:
	{
		if (get_user_flags(id) & ADMIN)
		{
		rcon_menu(id)
		}
	}
	case 7:
	{
		if (get_user_flags(id) & ADMIN)
		{
		client_cmd(id, "amxmodmenu");
		}
	}
	}
	}
	else
	{
	ColorChat(id, "%L", id, "NOT_FLAG")
	}
	menu_destroy(menu)
	return PLUGIN_HANDLED
}

public server_kill(id)
{
	if (get_user_flags(id) & ADMIN)
	{
	server_cmd("quit")
	}
	else
	{
	ColorChat(id, "%L", id, "NOT_FLAG")
	}
}

public server_restart(id)
{
	if (get_user_flags(id) & ADMIN)
	{
	server_cmd("restart")
	remove_task(0)
	}
	else
	{
	ColorChat(id, "%L", id, "NOT_FLAG")
	}
}

public message(id)
{
	if (get_user_flags(id) & ADMIN)
	{
	client_cmd(id,"messagemode server_cmd")
	}
	else
	{
	ColorChat(id, "%L", id, "NOT_FLAG")
	}
}

public CommandMessage(id)
{
	if (get_user_flags(id) & ADMIN)
	{
	new Args[256]
	read_args(Args,sizeof(Args)-1)
	remove_quotes(Args)
	
	get_cvar_string("rcon_password", rcon_last, 33)
	
	server_cmd("%s",Args)
	}
	else
	{
	ColorChat(id, "%L", id, "NOT_FLAG")
	}
}

public rcon_menu(id)
{
	if (get_user_flags(id) & ADMIN)
	{
	static cp_rcon_menu[128]
	formatex(cp_rcon_menu, charsmax(cp_rcon_menu), "%L", id, "RCON_MENU_NAME")
	new i_Menu = menu_create(cp_rcon_menu, "submenu_handler")

	static GET_RCON[64], CHANGE_RCON[64], OFF_RCON[64], Next[64], Back[64], Exit[64]
	formatex(GET_RCON, charsmax(GET_RCON), "%L", id, "GET_RCON")
	formatex(CHANGE_RCON, charsmax(CHANGE_RCON), "%L", id, "CHANGE_RCON")
	formatex(OFF_RCON, charsmax(OFF_RCON), "%L", id, "OFF_RCON")
	
	formatex(Next, charsmax(Next), "%L", id, "NEXT")
	formatex(Back, charsmax(Back), "%L", id, "BACK")
	formatex(Exit, charsmax(Exit), "%L", id, "EXIT")
	
	menu_additem(i_Menu, GET_RCON, "1")
	menu_additem(i_Menu, CHANGE_RCON, "2")
	menu_additem(i_Menu, OFF_RCON, "3")

	menu_setprop(i_Menu, MPROP_NEXTNAME, Next)
	menu_setprop(i_Menu, MPROP_BACKNAME, Back)
	menu_setprop(i_Menu, MPROP_EXITNAME, Exit)
	menu_display(id, i_Menu, 0)
	}
	else
	{
	ColorChat(id, "%L", id, "NOT_FLAG")
	}
}

public submenu_handler(id, menu, item)
{
	if (get_user_flags(id) & ADMIN)
	{
	if (item == MENU_EXIT)
	{
		menu_destroy(menu)

		if (is_user_connected(id))
		cpanel_menu(id)

		return PLUGIN_HANDLED
	}

	new s_Data[6], s_Name[64], i_Access, i_Callback
	menu_item_getinfo(menu, item, i_Access, s_Data, charsmax(s_Data), s_Name, charsmax(s_Name), i_Callback)

	new i_Key = str_to_num(s_Data)

	switch(i_Key)
	{
	case 1:
	{
		if (get_user_flags(id) & ADMIN)
		{
		new rcon[33]
		get_cvar_string("rcon_password", rcon, 33)
		ColorChat(id, "%L", id, "RCON_PASSWORD", rcon)
		}
	}
	case 2:
	{
		if (get_user_flags(id) & ADMIN)
		{
		client_cmd(id, "rcon_message")
		}
	}
	case 3:
	{
		if (get_user_flags(id) & ADMIN)
		{
		server_cmd("%L", id, "CVAR_OFF_RCON")
		ColorChat(id, "%L", id, "RCON_OFFED")
		}
	}
	}
	}
	else
	{
	ColorChat(id, "%L", id, "NOT_FLAG")
	}

	menu_destroy(menu)

	rcon_menu(id)

	return PLUGIN_HANDLED;
}

public message_2(id)
{
	if (get_user_flags(id) & ADMIN)
	{
	client_cmd(id,"messagemode new_rcon_password")
	}
	else
	{
	ColorChat(id, "%L", id, "NOT_FLAG")
	}
}

public CommandMessage_2(id)
{
	if (get_user_flags(id) & ADMIN)
	{
	new Args[256]
	read_args(Args,sizeof(Args)-1)
	remove_quotes(Args)

	server_cmd("rcon_password %s",Args)
	
	get_cvar_string("rcon_password", rcon_last, 33)
	set_task(2.0,"change_rcon",0,_,_,"b")
	}
	else
	{
	ColorChat(id, "%L", id, "NOT_FLAG")
	}
}

public change_rcon(id)
{
	if (get_user_flags(id) & ADMIN)
	{
	new rcon_new[33]
	get_cvar_string("rcon_password", rcon_new, 33)
	
	ColorChat(id, "%L", id, "RCON_PASSWORD_CHANGED", rcon_last, rcon_new)
	remove_task(0)
	}
	else
	{
	ColorChat(id, "%L", id, "NOT_FLAG")
	}
}
	
stock ColorChat(const id, const input[], any:...)
{
	new count = 1, players[32]
	static msg[191]
	vformat(msg, 190, input, 3)
     
	replace_all(msg, 190, "!g", "^4") // Green Color
	replace_all(msg, 190, "!y", "^1") // Default Color
	replace_all(msg, 190, "!t", "^3") // Team Color
   
	if(id)players[0] = id; else get_players(players, count, "ch")
	{
	for(new i = 0; i < count; i++)
	{
		if(is_user_connected(players[i]))
		{
		message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("SayText"), _, players[i])
		write_byte(players[i]);
		write_string(msg);
		message_end();
		}
	}
	}
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1049\\ f0\\ fs16 \n\\ par }
*/
